/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.event;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.schmarrn.lighty.DataProviders;
import dev.schmarrn.lighty.Renderers;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.compat.IrisCompat;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.BufferHolder;
import dev.schmarrn.lighty.overlaystate.SMACH;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6854;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_9958;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Compute {
    private static final int INITIAL_HASHSET_CAPACITY = 550;
    private static HashSet<class_4076> toBeUpdated = new HashSet(550);
    private static HashSet<class_4076> toBeRemoved = new HashSet(550);
    private static final Map<class_4076, BufferHolder> cachedBuffers = new HashMap<class_4076, BufferHolder>();
    private static class_1923 playerPos = null;
    private static int computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753());

    private static boolean outOfRange(class_4076 pos) {
        int computationDistanceSquared = computationDistance * computationDistance;
        if (playerPos == null) {
            return true;
        }
        int sqX = (pos.method_18674() - Compute.playerPos.field_9181) * (pos.method_18674() - Compute.playerPos.field_9181);
        int sqZ = (pos.method_18687() - Compute.playerPos.field_9180) * (pos.method_18687() - Compute.playerPos.field_9180);
        return sqX > computationDistanceSquared || sqZ > computationDistanceSquared;
    }

    public static void clear() {
        toBeUpdated = new HashSet(550);
        cachedBuffers.forEach((sectionPos, vertexBuffer) -> vertexBuffer.close());
        cachedBuffers.clear();
        computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753());
    }

    public static void updateBlockPos(class_2338 pos) {
        class_4076 spos = class_4076.method_18682((class_2338)pos);
        if (spos.method_19528() == pos.method_10264()) {
            Compute.updateSubChunk(spos.method_34591(0, -1, 0));
        }
        Compute.updateSubChunk(spos);
    }

    public static void updateSubChunk(class_4076 pos) {
        if (Compute.outOfRange(pos)) {
            return;
        }
        toBeUpdated.add(pos);
    }

    private static BufferHolder buildChunk(OverlayRenderer renderer, List<OverlayDataProvider> dataProviders, class_4076 chunkPos, class_289 tesselator, class_638 world) {
        ArrayList<OverlayData> overlayData = new ArrayList<OverlayData>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    class_2338 pos = chunkPos.method_19767().method_10069(x, y, z);
                    for (OverlayDataProvider dataProvider : dataProviders) {
                        OverlayData data = dataProvider.compute(world, pos, new class_2382(x, y, z));
                        if (!data.valid()) continue;
                        overlayData.add(data);
                    }
                }
            }
        }
        class_287 builder = renderer.beforeBuild(tesselator);
        int overlayBrightness = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
        int lightmap = class_765.method_23687((int)overlayBrightness, (int)overlayBrightness);
        for (OverlayData data : overlayData) {
            renderer.build(world, data.pos(), data, builder, lightmap);
        }
        BufferHolder buffer = cachedBuffers.get(chunkPos);
        if (buffer == null) {
            buffer = new BufferHolder();
        }
        if (!overlayData.isEmpty()) {
            buffer.upload(builder.method_60794());
        }
        return buffer;
    }

    public static void computeCache(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        SMACH.updateCompute(client);
        if (!SMACH.isEnabled()) {
            return;
        }
        List<OverlayDataProvider> dataProviders = DataProviders.getActiveProviders();
        OverlayRenderer renderer = Renderers.getRenderer();
        class_638 world = client.field_1687;
        if (client.field_1724 == null || world == null) {
            return;
        }
        cachedBuffers.forEach((sectionPos, bufferHolder) -> {
            if (Compute.outOfRange(sectionPos)) {
                toBeRemoved.add((class_4076)sectionPos);
            }
        });
        HashSet<class_4076> removeFromToBeUpdated = new HashSet<class_4076>(550);
        for (class_4076 sectionPos2 : toBeUpdated) {
            if (Compute.outOfRange(sectionPos2)) {
                toBeRemoved.add(sectionPos2);
                continue;
            }
            if (!class_310.method_1551().field_1769.method_40050(sectionPos2.method_19767())) continue;
            removeFromToBeUpdated.add(sectionPos2);
            cachedBuffers.compute(sectionPos2, (pos, vertexBuffer) -> {
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                return Compute.buildChunk(renderer, dataProviders, pos, class_289.method_1348(), world);
            });
        }
        for (class_4076 pos2 : removeFromToBeUpdated) {
            toBeUpdated.remove(pos2);
        }
        for (class_4076 sectionPos2 : toBeRemoved) {
            toBeUpdated.remove(sectionPos2);
            BufferHolder buf = cachedBuffers.remove(sectionPos2);
            if (buf == null) continue;
            buf.close();
        }
        toBeRemoved = new HashSet(550);
    }

    public static void render(@Nullable class_4604 frustum, class_4587 matrixStack, Matrix4f projectionMatrix) {
        if (!SMACH.isEnabled()) {
            return;
        }
        if (frustum == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_638 world = minecraft.field_1687;
        if (world == null) {
            return;
        }
        OverlayRenderer renderer = Renderers.getRenderer();
        renderer.beforeRendering();
        class_757 gameRenderer = minecraft.field_1773;
        class_4184 camera = gameRenderer.method_19418();
        playerPos = new class_1923(camera.method_19328());
        matrixStack.method_22903();
        IrisCompat.fixIrisShaders(matrixStack, camera, gameRenderer, minecraft);
        matrixStack.method_23760().method_23761().rotate((Quaternionfc)camera.method_23767().conjugate(new Quaternionf()));
        class_243 camPos = camera.method_19326();
        class_5944 shader = RenderSystem.getShader();
        float renderDistance = class_310.method_1551().field_1773.method_3193() * 16.0f * 4012.0f;
        float fogStart = renderDistance - class_3532.method_15363((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f);
        class_9958 oldFog = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((class_9958)new class_9958(fogStart, renderDistance, class_6854.field_36351, 0.0f, 0.0f, 0.0f, 0.0f));
        matrixStack.method_22903();
        for (int x = -computationDistance + 1; x < computationDistance; ++x) {
            for (int z = -computationDistance + 1; z < computationDistance; ++z) {
                class_1923 chunkPos = new class_1923(Compute.playerPos.field_9181 + x, Compute.playerPos.field_9180 + z);
                for (int i = 0; i < world.method_32890(); ++i) {
                    class_4076 chunkSection = class_4076.method_18681((class_1923)chunkPos, (int)(world.method_32891() + i));
                    if (cachedBuffers.containsKey(chunkSection)) {
                        BufferHolder cachedBuffer = cachedBuffers.get(chunkSection);
                        if (!cachedBuffer.isValid() || !frustum.method_23093(class_238.method_54784((class_2338)chunkSection.method_19767().method_10069(-1, -1, -1), (class_2338)chunkSection.method_19767().method_10069(16, 16, 16)))) continue;
                        class_243 origin = new class_243((class_2382)chunkSection.method_19767());
                        class_243 dPos = origin.method_1020(camPos);
                        cachedBuffer.draw(matrixStack.method_23760().method_56822().method_23761().translate((float)dPos.method_10216(), (float)dPos.method_10214(), (float)dPos.method_10215()), projectionMatrix, shader);
                        continue;
                    }
                    toBeUpdated.add(chunkSection);
                }
            }
        }
        matrixStack.method_22909();
        RenderSystem.setShaderFog((class_9958)oldFog);
        matrixStack.method_22909();
        renderer.afterRendering();
    }

    private Compute() {
    }
}

