/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_313;

@Environment(value=EnvType.CLIENT)
public final class MonitorInfo {
    private final int viewportX;
    private final int viewportY;
    private final int width;
    private final int height;

    public MonitorInfo(int viewportX, int viewportY, int width, int height) {
        this.viewportX = viewportX;
        this.viewportY = viewportY;
        this.width = width;
        this.height = height;
    }

    public static MonitorInfo of(class_313 monitor) {
        return new MonitorInfo(monitor.method_1616(), monitor.method_1618(), monitor.method_1617().method_1668(), monitor.method_1617().method_1669());
    }

    public static MonitorInfo primary() {
        return new MonitorInfo(0, 0, -1, -1);
    }

    public static Optional<MonitorInfo> parse(String format) {
        if (format == null) {
            return Optional.empty();
        }
        String[] stringParts = format.split(",");
        int[] parts = new int[4];
        parts[1] = 0;
        parts[0] = 0;
        parts[3] = -1;
        parts[2] = -1;
        int length = Math.min(stringParts.length, parts.length);
        for (int i = 0; i < length; ++i) {
            try {
                parts[i] = Integer.parseInt(stringParts[i]);
                continue;
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.of(new MonitorInfo(parts[0], parts[1], parts[2], parts[3]));
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return this.viewportX + "," + this.viewportY + "," + this.width + "," + this.height;
    }
}

