/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.zoomify.zoom;

import dev.isxander.zoomify.utils.TransitionType;
import dev.isxander.zoomify.zoom.TimedInterpolator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0002\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0017\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Ldev/isxander/zoomify/zoom/TransitionInterpolator;", "Ldev/isxander/zoomify/zoom/TimedInterpolator;", "Lkotlin/Function0;", "Ldev/isxander/zoomify/utils/TransitionType;", "transitionIn", "transitionOut", "", "timeIn", "timeOut", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "targetInterpolation", "currentInterpolation", "tickDelta", "tickInterpolation", "(DDD)D", "interpolation", "modifyInterpolation", "(D)D", "modifyPrevInterpolation", "Lkotlin/jvm/functions/Function0;", "getTransitionIn", "()Lkotlin/jvm/functions/Function0;", "getTransitionOut", "activeTransition", "Ldev/isxander/zoomify/utils/TransitionType;", "inactiveTransition", "prevTargetInterpolation", "D", "", "justSwappedTransition", "Z", "isSmooth", "()Z", "Zoomify"})
public final class TransitionInterpolator
extends TimedInterpolator {
    @NotNull
    private final Function0<TransitionType> transitionIn;
    @NotNull
    private final Function0<TransitionType> transitionOut;
    @NotNull
    private TransitionType activeTransition;
    @NotNull
    private TransitionType inactiveTransition;
    private double prevTargetInterpolation;
    private boolean justSwappedTransition;

    public TransitionInterpolator(@NotNull Function0<? extends TransitionType> transitionIn, @NotNull Function0<? extends TransitionType> transitionOut, @NotNull Function0<Double> timeIn, @NotNull Function0<Double> timeOut) {
        Intrinsics.checkNotNullParameter(transitionIn, (String)"transitionIn");
        Intrinsics.checkNotNullParameter(transitionOut, (String)"transitionOut");
        Intrinsics.checkNotNullParameter(timeIn, (String)"timeIn");
        Intrinsics.checkNotNullParameter(timeOut, (String)"timeOut");
        super(timeIn, timeOut);
        this.transitionIn = transitionIn;
        this.transitionOut = () -> TransitionInterpolator.transitionOut$lambda$0(transitionOut);
        this.activeTransition = (TransitionType)this.transitionIn.invoke();
        this.inactiveTransition = (TransitionType)transitionOut.invoke();
    }

    @NotNull
    public final Function0<TransitionType> getTransitionIn() {
        return this.transitionIn;
    }

    @NotNull
    public final Function0<TransitionType> getTransitionOut() {
        return this.transitionOut;
    }

    @Override
    public double tickInterpolation(double targetInterpolation, double currentInterpolation, double tickDelta) {
        double currentInterpolationMod = currentInterpolation;
        if (targetInterpolation > currentInterpolation) {
            this.activeTransition = (TransitionType)this.transitionIn.invoke();
            this.inactiveTransition = (TransitionType)this.transitionOut.invoke();
            if (this.prevTargetInterpolation < targetInterpolation && this.activeTransition.hasInverse()) {
                this.justSwappedTransition = true;
                currentInterpolationMod = this.activeTransition.inverse(this.inactiveTransition.apply(currentInterpolationMod));
            }
        } else if (targetInterpolation < currentInterpolation) {
            this.activeTransition = (TransitionType)this.transitionOut.invoke();
            this.inactiveTransition = (TransitionType)this.transitionIn.invoke();
            if (this.prevTargetInterpolation > targetInterpolation && this.activeTransition.hasInverse()) {
                this.justSwappedTransition = true;
                currentInterpolationMod = this.activeTransition.inverse(this.inactiveTransition.apply(currentInterpolationMod));
            }
        }
        this.prevTargetInterpolation = targetInterpolation;
        if (this.activeTransition == TransitionType.INSTANT) {
            return targetInterpolation;
        }
        return super.tickInterpolation(targetInterpolation, currentInterpolationMod, tickDelta);
    }

    @Override
    public double modifyInterpolation(double interpolation) {
        return this.activeTransition.apply(interpolation);
    }

    @Override
    public double modifyPrevInterpolation(double interpolation) {
        if (this.justSwappedTransition) {
            this.justSwappedTransition = false;
            return this.activeTransition.inverse(this.inactiveTransition.apply(interpolation));
        }
        return interpolation;
    }

    @Override
    public boolean isSmooth() {
        return !this.justSwappedTransition && super.isSmooth() && this.activeTransition != TransitionType.INSTANT;
    }

    private static final TransitionType transitionOut$lambda$0(Function0 $transitionOut) {
        return ((TransitionType)$transitionOut.invoke()).opposite();
    }
}

