/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.client;

import com.mojang.brigadier.CommandDispatcher;
import fuzs.forgeconfigapiport.fabric.impl.client.commands.ClientConfigCommand;
import fuzs.forgeconfigapiport.fabric.impl.network.ConfigSync;
import fuzs.forgeconfigapiport.fabric.impl.network.payload.ConfigFilePayload;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ForgeConfigAPIPortFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ForgeConfigAPIPortFabricClient.registerMessages();
        ForgeConfigAPIPortFabricClient.registerEventHandlers();
    }

    private static void registerMessages() {
        ClientConfigurationNetworking.registerGlobalReceiver(ConfigFilePayload.TYPE, (payload, context) -> ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName()));
        ClientPlayNetworking.registerGlobalReceiver(ConfigFilePayload.TYPE, (payload, context) -> ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName()));
    }

    private static void registerEventHandlers() {
        ClientCommandRegistrationCallback.EVENT.register((commandDispatcher, commandBuildContext) -> ClientConfigCommand.register((CommandDispatcher<FabricClientCommandSource>)commandDispatcher));
        ClientConfigurationConnectionEvents.COMPLETE.register((handler, client) -> ConfigSync.handleClientLoginSuccess());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ModConfigs.getFileMap().values().forEach(config -> {
            IConfigSpec patt0$temp = config.getSpec();
            if (patt0$temp instanceof ModConfigSpec) {
                ModConfigSpec spec = (ModConfigSpec)patt0$temp;
                spec.resetCaches(ModConfigSpec.RestartType.WORLD);
            }
        }));
    }
}

