/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.network;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import fuzs.forgeconfigapiport.fabric.api.v5.ModConfigEvents;
import fuzs.forgeconfigapiport.fabric.impl.network.payload.ConfigFilePayload;
import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.class_8710;
import net.minecraft.class_8735;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfigSync {
    private static final Object lock = new Object();
    private static final Map<class_2535, Map<String, byte[]>> configsToSync = new WeakHashMap<class_2535, Map<String, byte[]>>();
    private static boolean isVanillaConnection = true;

    private ConfigSync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncAllConfigs(class_8735 listener) {
        class_2535 connection = ((class_8609)listener).field_45013;
        if (connection.method_10756()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            configsToSync.put(connection, new LinkedHashMap());
        }
        Map<String, byte[]> configData = ModConfigs.getConfigSet(ModConfig.Type.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, mc -> {
            try {
                return Files.readAllBytes(mc.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        for (Map.Entry<String, byte[]> entry : configData.entrySet()) {
            ((class_8609)listener).method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new ConfigFilePayload(entry.getKey(), entry.getValue())));
        }
    }

    public static void registerEventListeners() {
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            ModConfigEvents.reloading(modContainer.getMetadata().getId()).register(config -> {
                if (config.getType() != ModConfig.Type.SERVER) {
                    return;
                }
                IConfigSpec.ILoadedConfig loadedConfig = config.getLoadedConfig();
                if (loadedConfig == null) {
                    return;
                }
                ConfigFormat configFormat = loadedConfig.config().configFormat();
                if (configFormat.isInMemory()) {
                    return;
                }
                byte[] bytes = configFormat.createWriter().writeToString((UnmodifiableConfig)loadedConfig.config()).getBytes(StandardCharsets.UTF_8);
                Object object = lock;
                synchronized (object) {
                    for (Map<String, byte[]> toSync : configsToSync.values()) {
                        toSync.put(config.getFileName(), bytes);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncPendingConfigs(MinecraftServer server) {
        Object object = lock;
        synchronized (object) {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!ServerPlayNetworking.canSend((class_3244)player.field_13987, ConfigFilePayload.TYPE) || player.field_13987.field_45013.method_10756()) continue;
                Map<String, byte[]> toSync = configsToSync.get(player.field_13987.field_45013);
                if (toSync == null) {
                    if (player.getClass() != class_3222.class) continue;
                    throw new IllegalStateException("configsToSync should contain an entry for player " + String.valueOf(player.method_5477()));
                }
                toSync.forEach((fileName, data) -> player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new ConfigFilePayload((String)fileName, (byte[])data))));
                toSync.clear();
            }
        }
    }

    public static void receiveSyncedConfig(byte[] contents, String fileName) {
        ConfigSync.onEstablishModdedConnection();
        Optional.ofNullable(ModConfigs.getFileMap().get(fileName)).ifPresent(mc -> ConfigTracker.acceptSyncedConfig(mc, contents));
    }

    private static void onEstablishModdedConnection() {
        isVanillaConnection = false;
        ForgeConfigAPIPort.LOGGER.debug("Received modded connection marker from server");
    }

    public static void handleClientLoginSuccess() {
        if (isVanillaConnection) {
            ForgeConfigAPIPort.LOGGER.debug("Connected to a vanilla server. Catching up missing behaviour.");
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        } else {
            isVanillaConnection = true;
            ForgeConfigAPIPort.LOGGER.debug("Connected to a modded server.");
        }
    }
}

